/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.forgespi.locating.IModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackgroundScanHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ExecutorService modContentScanner;
    private final List<ModFile> pendingFiles;
    private final List<ModFile> scannedFiles;
    private final List<ModFile> allFiles;
    private final Map<IModFile.Type, List<ModFile>> modFiles;
    private LoadingModList loadingModList;

    public BackgroundScanHandler(Map<IModFile.Type, List<ModFile>> modFiles) {
        this.modFiles = modFiles;
        this.modContentScanner = Executors.newSingleThreadExecutor(r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setDaemon(true);
            return thread;
        });
        this.scannedFiles = new ArrayList<ModFile>();
        this.pendingFiles = new ArrayList<ModFile>();
        this.allFiles = new ArrayList<ModFile>();
    }

    public Map<IModFile.Type, List<ModFile>> getModFiles() {
        return this.modFiles;
    }

    public void submitForScanning(ModFile file) {
        if (this.modContentScanner.isShutdown()) {
            throw new IllegalStateException("Scanner has shutdown");
        }
        this.allFiles.add(file);
        this.pendingFiles.add(file);
        CompletionStage future = ((CompletableFuture)CompletableFuture.supplyAsync(file::compileContent, this.modContentScanner).whenComplete(file::setScanResult)).whenComplete((r, t) -> this.addCompletedFile(file, (ModFileScanData)r, (Throwable)t));
        file.setFutureScanResult((CompletableFuture<ModFileScanData>)future);
    }

    private void addCompletedFile(ModFile file, ModFileScanData modFileScanData, Throwable throwable) {
        if (throwable != null) {
            LOGGER.error(LogMarkers.SCAN, "An error occurred scanning file {}", (Object)file, (Object)throwable);
        }
        this.pendingFiles.remove(file);
        this.scannedFiles.add(file);
    }

    public void setLoadingModList(LoadingModList loadingModList) {
        this.loadingModList = loadingModList;
    }

    public LoadingModList getLoadingModList() {
        return this.loadingModList;
    }

    public void waitForScanToComplete(Runnable ticker) {
        this.modContentScanner.shutdown();
        do {
            ticker.run();
            try {
                this.modContentScanner.awaitTermination(50L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        } while (!this.modContentScanner.isShutdown());
    }
}

